#include <ModuleSerialCore.h>
#include <ModuleSerialGprs.h>
#include <ModuleSerialGps.h>

#define SIM_APN "web.vodafone.de"
#define SIM_APN_USERNAME ""
#define SIM_APN_PASSWORD ""

String MLO_USERNAME = "Organisation";
String MLO_TID = "tid";

#define PIN_RX 2
#define PIN_TX 3
#define PIN_START_SIM808 9

#define PIN_STATUS_GPRS 4
#define PIN_STATUS_GPS 5
#define PIN_STATUS_SEND 6

float radius_of_earth = 6378.1; // km

const float REF_VOLTAGE = 3.7;
unsigned long previousMillis = 0;
const long INTERVALL_SEND = 60000;
const bool OnlineDebugMode = true;
const bool SerialDebugMode = true;
const bool DistanceCheck = false;

float last_lat = 0;
float last_long = 0;

ModuleSerialCore core(PIN_RX, PIN_TX);    // Begin a SoftwareSerial connection on rx and tx pins.
ModuleSerialGprs gprs(&core);   // Pass a reference to the core.
ModuleSerialGps gps(&core);     // Pass a reference to the core.

double distance_in_m(float start_lat, float start_long, float end_lat, float end_long) {
  // / 180 / PI converts degrees to radians
  start_lat/= 180 / PI; 
  start_long/= 180 / PI;
  end_lat/= 180 / PI;
  end_long/= 180 / PI;
  
  // haversine formula - based on implementation at http://www.movable-type.co.uk/scripts/latlong.html
  float a = pow(sin((end_lat-start_lat)/2), 2) + cos(start_lat) * cos(end_lat) * pow(sin((end_long-start_long)/2), 2);
  float answer = radius_of_earth * 2 * atan2(sqrt(a), sqrt(1-a));
  answer = answer * 1000; 
  return double(answer);
}


void setup() 
{
    Serial.begin(9600);
    while (!Serial);

    Serial.println(F("Initializing..."));

    pinMode(PIN_STATUS_GPRS, OUTPUT);
    pinMode(PIN_STATUS_GPS, OUTPUT);
    pinMode(PIN_STATUS_SEND, OUTPUT);
    pinMode(PIN_START_SIM808, OUTPUT);

    digitalWrite(PIN_STATUS_GPRS, LOW);
    digitalWrite(PIN_STATUS_GPS, LOW);
    digitalWrite(PIN_STATUS_SEND, LOW);
    digitalWrite(PIN_START_SIM808, LOW);  

    digitalWrite(PIN_STATUS_SEND, HIGH);
    digitalWrite(PIN_START_SIM808, HIGH);      
    delay(3000);
    digitalWrite(PIN_START_SIM808, LOW);      
    digitalWrite(PIN_STATUS_SEND, LOW);          

    bool notConnected = true;

    while (notConnected)
    {
        core.debug(&Serial);    // Pass a reference to HardwareSerial if you want debugging printed to the Serial Monitor.

        if (core.begin(4800) == MODULE_READY && gprs.enable(SIM_APN, SIM_APN_USERNAME, SIM_APN_PASSWORD) == GPRS_ENABLED)
        {
            notConnected = false;
        }
        else 
        {
            Serial.println(F("Failed to connect."));
            delay(1000);
        }
    }

    digitalWrite(PIN_STATUS_GPRS, HIGH);

    notConnected = true;
    while (notConnected)
    {
        if ( gps.enable() == GPS_ENABLED)
        {
            notConnected = false;
            Serial.println(F("Connected to GPS"));
        }
        else 
        {
            Serial.println(F("Failed to connect."));
            delay(1000);
        }
    }   

    digitalWrite(PIN_STATUS_GPS, HIGH);    
}

bool CanSend(float Distance) {
  bool SendPosition = false;

  if ( Distance > 15 ) {
    SendPosition = true;   
  }

  if ( DistanceCheck == false ) {
    SendPosition = true;     
  }

  return SendPosition;
}

void SendPosition(float posLat, float posLong, int SatCount ) {
   
  posLat = convertDegMinToDecDeg(posLat);
  posLong = convertDegMinToDecDeg(posLong);
  
  if ( posLat != 0.0 && posLong != 0.0 ) {
    double d = distance_in_m(posLat, posLong, last_lat, last_long);
    float Distance = (float)d;

    if ( CanSend(Distance) == true ) {
      String StringUrl = "http://api.mobile-lagekarte.de/InsertData.php?id="+String(MLO_TID)+"&lat="+String(posLat, 6)+"&long="+String(posLong, 6)+"&orga="+String(MLO_USERNAME);//+"&dis="+String(Distance);//+"&v="+VoltageString
      
      char *url = StringUrl.c_str();
  
      gprs.openHttpConnection();
      ModuleSerialGprs::HttpResponse httpResponse = gprs.sendHttpRequest(HTTP_GET, url, 6000);    // Method, url and timeout in milliseconds.
  
      if (httpResponse.statusCode == 200)
      {
          Serial.println(F("Request success!"));
  
          char response[500] = "";
          int length = httpResponse.contentLength + 50 > 500 ? 450 : httpResponse.contentLength;   // Read the first 450 characters of the response.
  
          gprs.readHttpResponse(length, response, 500);
  
          Serial.println(response);
  
          last_lat = posLat;
          last_long = posLong;
      }
      else
      {
          Serial.println(F("Request failed."));
      }
  
      gprs.closeHttpConnection();
    }
    else
    {
           Serial.println("Distance too small, no api call");     
    }
  }
  else
  {
    if ( OnlineDebugMode ) {
       String Message = "";//"GPS:NoPosition,GPSInfo:SatCount:" + String(SatCount) + "";
       //LogTransponderMessage( Message );
    }
  }
}

void LogTransponderMessage( String Message ) {

    String StringUrl = "";

    StringUrl += "http://k-medien.net/api/LogTransponderMessage?id=at1&orga=Matze&message=test";
    StringUrl += Message;
      
    char *url = StringUrl.c_str();
  
    gprs.openHttpConnection();
    ModuleSerialGprs::HttpResponse httpResponse = gprs.sendHttpRequest(HTTP_GET, url, 6000);    // Method, url and timeout in milliseconds.
    
    if (httpResponse.statusCode == 200)
    {
        Serial.println(F("Request success!"));
    
        char response[500] = "";
        int length = httpResponse.contentLength + 50 > 500 ? 450 : httpResponse.contentLength;   // Read the first 450 characters of the response.
    
        gprs.readHttpResponse(length, response, 500);
    
        Serial.println(response);
    }
    else
    {
        Serial.println(F("Request failed."));
    }
    
    gprs.closeHttpConnection();
}

double convertDegMinToDecDeg (float degMin) {
  double min = 0.0;
  double decDeg = 0.0;

  //get the minutes, fmod() requires double
  min = fmod((double)degMin, 100.0);

  //rebuild coordinates in decimal degrees
  degMin = (int) ( degMin / 100 );
  decDeg = degMin + ( min / 60 );

  return decDeg;
}

void loop() 
{
  unsigned long currentMillis = millis();
 
  if (currentMillis - previousMillis >= INTERVALL_SEND)
  {
    previousMillis = currentMillis;  
    ModuleSerialGps::GpsData gpsData = gps.currentGpsData();

    Serial.println(F("\nCurrent GPS data: "));
    Serial.print("GPS: lat=");
    
    Serial.print(gpsData.lat);
    Serial.print(" / lng=");
    Serial.print(gpsData.lng);
    Serial.print(" / sat=");
    Serial.println(gpsData.sat);

    digitalWrite(PIN_STATUS_SEND, HIGH);  
    SendPosition(gpsData.lng, gpsData.lat, gpsData.sat );
    digitalWrite(PIN_STATUS_SEND, LOW);  
    
    }
}